from abc import abstractclassmethod
from dataclasses import dataclass
from typing import *
from enum import Enum


class Predicate(Enum):
    Between = 1
    EqualTo = 2
    GreaterThan = 3
    GreaterThanOrEqual = 4
    Invalid = 5
    LessThan = 6
    LessThanOrEqual = 7
    NotBetween = 8
    NotEqualTo = 9
    ColorScale = 10
    Formula = 11
    IconSet = 12
    AboveAverage = 13
    BelowAverage = 14
    Blanks = 15
    DuplicateValues = 16
    EqualOrAboveAverage = 17
    EqualOrBelowAverage = 18
    Errors = 19
    LastMonth = 20
    LastSevenDays = 21
    LastWeek = 22
    NextMonth = 23
    NextWeek = 24
    NonBlanks = 25
    NonErrors = 26
    OneStdDevAboveAverage = 27
    OneStdDevBelowAverage = 28
    ThisMonth = 29
    ThisWeek = 30
    ThreeStdDevAboveAverage = 31
    ThreeStdDevBelowAverage = 32
    Today = 33
    Tomorrow = 34
    TwoStdDevAboveAverage = 35
    TwoStdDevBelowAverage = 36
    UniqueValues = 37
    Yesterday = 38
    Contains = 39
    NotContains = 40
    BeginsWith = 41
    EndsWith = 42
    TopBottom = 43
    DataBar = 44


class Criterion(Enum):
    LowestValue = 1
    HighestValue = 2
    Number = 3
    Percent = 4
    Formula = 5
    Percentile = 6
    GreaterThan = 7
    GreaterThanOrEqual = 8
    TopItems = 9
    TopPercent = 10
    BottomItems = 11
    BottomPercent = 12
    LeftToRight = 13
    RightToLeft = 14


EquivalentSet = [
    set(
        [
            Predicate.Contains,
            Predicate.EqualTo,
            Predicate.BeginsWith,
            Predicate.EndsWith,
        ]
    ),
    set([Predicate.GreaterThan, Predicate.GreaterThanOrEqual]),
    set([Predicate.LessThan, Predicate.LessThanOrEqual]),
    set([Predicate.Blanks, Predicate.NotEqualTo]),
    set([Predicate.BelowAverage, Predicate.AboveAverage]),
]


@dataclass
class OfficeJSPredicate:
    pred: Predicate
    optional: List[Criterion]

    def __str__(self):
        optional_str = ", ".join([m.name for m in self.optional])
        return f"{self.pred}({optional_str})"

    def __rer__(self):
        return self.__str__()
